import os

def create_docker_dir(dir_name):
  try:
    if os.path.exists(f'{dir_name}/docker'):
      print(f'Папка с именем docker существует!')
    else:
      path_string = os.path.join(dir_name, 'docker')
      os.makedirs(path_string)
      print('Папка docker создана')
  except OSError as error:
    print(error)
    
def create_docker_compose(dir_name, domen):
  try:
    if os.path.exists(f'{dir_name}/docker_compose.yml'):
      print('docker-compose.yml уже существует')
    else:
      port = input('Введите номер порта: ')
      docker_compose_content = f"""
version: "3.7"

services:

  nginx:
    container_name: {domen}.nginx
    image: {domen}/nginx:latest
    build:
      context: ./docker/nginx
      dockerfile: Dockerfile
    restart: always
    ports:
      - "{port}:80"
    volumes:
      - ./public:/srv/www
    expose:
      - 80
    logging:
      driver: "json-file"
      options:
        max-size: "1m"
        max-file: "1"
      """
      with open(f'{dir_name}/docker-compose.yml', 'w', encoding="utf-8") as docker:
        docker.write(docker_compose_content)
  except OSError as error:
    print(error)
    
def create_nginx_docker(dir_name, page):
  try:
    if os.path.exists(f'{dir_name}/nginx'):
      print('Папка nginx уже существует')
    else:
      path_string = os.path.join(dir_name, 'docker', 'nginx')
      os.makedirs(path_string)
      dockerfile_content = """
      FROM nginx

COPY ./*.conf               /etc/nginx/
COPY ./sites-enabled/*.conf /etc/nginx/sites-enabled/

WORKDIR /srv/www

EXPOSE 80

CMD ["nginx", "-g", "daemon off;"]
      """
      with open(f'{path_string}/Dockerfile', 'w', encoding="utf-8") as docker:
        docker.write(dockerfile_content)
      dockerignore_content = """Docketfile"""
      with open(f'{path_string}/.dockerignore', 'w', encoding="utf-8") as dockerignore:
        dockerignore.write(dockerignore_content)
      create_fastcgi(dir_name, path_string)
      create_nginx_conf(path_string)
      create_default_conf(path_string, page)
  except OSError as error:
    print(error)
    
def create_fastcgi(dir_name, path_string):
  try:
    if os.path.exists(f'{dir_name}/nginx'):
      print('Папка nginx уже существует')
    else:
      fastcgi_content = """
fastcgi_param  GATEWAY_INTERFACE  CGI/1.1;
fastcgi_param  SERVER_SOFTWARE    nginx;
fastcgi_param  QUERY_STRING       $query_string;
fastcgi_param  REQUEST_METHOD     $request_method;
fastcgi_param  CONTENT_TYPE       $content_type;
fastcgi_param  CONTENT_LENGTH     $content_length;
fastcgi_param  SCRIPT_FILENAME    $document_root$fastcgi_script_name;
fastcgi_param  SCRIPT_NAME        $fastcgi_script_name;
fastcgi_param  REQUEST_URI        $request_uri;
fastcgi_param  DOCUMENT_URI       $document_uri;
fastcgi_param  DOCUMENT_ROOT      $document_root;
fastcgi_param  SERVER_PROTOCOL    $server_protocol;
fastcgi_param  REMOTE_ADDR        $remote_addr;
fastcgi_param  REMOTE_PORT        $remote_port;
fastcgi_param  SERVER_ADDR        $server_addr;
fastcgi_param  SERVER_PORT        $server_port;
fastcgi_param  SERVER_NAME        $server_name;
      """
      with open(f'{path_string}/fastcgi.conf', 'w', encoding='utf-8') as fastcgi:
        fastcgi.write(fastcgi_content)
  except OSError as error:
    print(error)
    
def create_nginx_conf(path_string):
  try:
    if os.path.exists(f'{path_string}/nginx.conf'):
      print('nginx.conf уже сушествует!')
    else:
      nginx_content = """
user www-data;
worker_processes 8;
pid /run/nginx.pid;
error_log /dev/stdout error;

events {
    worker_connections  2048;
    multi_accept on;
    use epoll;
}

http {
    server_tokens           off;
    sendfile                on;
    tcp_nopush              on;
    tcp_nodelay             on;
    keepalive_timeout       10;
    types_hash_max_size     2048;
    include                 /etc/nginx/mime.types;
    default_type            application/octet-stream;
    access_log              on;
    error_log               on;
    gzip                    on;
    gzip_disable            "msie6";
    open_file_cache         max=100;

    include                 /etc/nginx/sites-enabled/*.conf;

    client_body_temp_path   /tmp/client_temp;
    proxy_temp_path         /tmp/proxy_temp_path;
    fastcgi_temp_path       /tmp/fastcgi_temp;
    uwsgi_temp_path         /tmp/uwsgi_temp;
    scgi_temp_path          /tmp/scgi_temp;
}
      """
      with open(f'{path_string}/nginx.conf', 'w', encoding='utf-8') as nginx:
        nginx.write(nginx_content)
  except OSError as error:
    print(error)
    
def create_default_conf(path_string, page):
  try:
    
    if os.path.exists(f'{path_string}/sites-enabled'):
      print('Папка sites-enabled уже существует')
    else:
      path = os.path.join(path_string, 'sites-enabled')
      os.makedirs(path)
      default_conf = f"""
server {{
    listen        80;

    access_log    /dev/stdout combined;
    error_log     /dev/stdout error;

    root          /srv/www;
    index         swap.html;

    error_page    404 /404.html;

    location / {{
      return 404;
    }}

    location = /404.html {{
      root  /srv/www;
    }}

    location /{page} {{
        try_files $uri $uri/ /{page}.html;
    }}

    location ~* \.(js|jpg|png|css|svg|woff2|json|otf|ttf|ico)$ {{
        root /srv/www;
        add_header Cache-Control "public";
    }}
}}
      """
      with open(f"{path}/default.conf", 'w', encoding="utf-8") as default:
        default.write(default_conf)
  except OSError as error:
    print(error)